'/***
'*math.h - definitions and declarations for math library
'*
'*       Copyright (c) 1985-1997, Microsoft Corporation. All rights reserved.
'*
'*Purpose:
'*       This file contains constant definitions and external subroutine
'*       declarations for the math subroutine library.
'*       [ANSI/System V]
'*
'*       [Public]
'*
'****/

#If Not %Def(%MATH_INC)
    %MATH_INC = 1

'/*
' * Currently, all MS C compilers for Win32 platforms default to 8 byte
' * alignment.
' */
'#pragma pack(push,8)

'/* Definition of _exception struct - this struct is passed to the matherr
' * routine when a floating point exception is detected
' */

#If Not %Def(%EXCEPTION_DEFINED)
%EXCEPTION_DEFINED = 1
Type tagException
   Type   As Long         ' char /* exception type - see below */
   Name   As Asciiz Ptr   ' char * /* name of function where error occured */
   arg1   As Double       ' double /* first argument to function */
   arg2   As Double       ' double /* second argument (if any) to function */
   retval As Double       ' double /* value to be returned by function */
End Type
#EndIf


'/* Definition of a _complex struct to be used by those who use cabs and
' * want type checking on their argument
' */

#If Not %Def(%COMPLEX_DEFINED)
%COMPLEX_DEFINED = 1
Type tagComplex
   x As Double   ' real part
   y As Double   ' imaginary part
End Type
#EndIf


'/* Constant definitions for the exception type passed in the _exception struct
' */

%DOMAIN_    = 1   ' /* argument domain error */
%SING_      = 2   ' /* argument singularity */
%OVERFLOW_  = 3   ' /* overflow range error */
%UNDERFLOW_ = 4   ' /* underflow range error */
%TLOSS_     = 5   ' /* total loss of precision */
%PLOSS_     = 6   ' /* partial loss of precision */

%EDOM       = 33
%ERANGE     = 34


'/* Definitions of _HUGE and HUGE_VAL - respectively the XENIX and ANSI names
' * for a value returned in case of error by a number of the floating point
' * math routines
' */
'_CRTIMP extern double _HUGE;
'#define HUGE_VAL _HUGE

Function HUGE_VAL () As Double
   Local hLib As Dword
   Local phuge As Double Ptr
   hLib = LoadLibrary("msvcrt.dll")
   If hLib Then
      phuge = GetProcAddress(hLib, "_HUGE")
      If phuge Then Function = @phuge
      FreeLibrary hLib
   End If
End Function


'/* Function prototypes */

'_CRTIMP int     __cdecl abs(int);
Declare Function abs_ CDecl Lib "msvcrt.dll" Alias "abs" ( _
   ByVal Long _                             ' int n
   ) As Long                                ' int

'_CRTIMP double  __cdecl acos(double);
Declare Function acos_ CDecl Lib "msvcrt.dll" Alias "acos" ( _
   ByVal Double _                           ' double x
   ) As Double                              ' double

'_CRTIMP double  __cdecl asin(double);
Declare Function asin_ CDecl Lib "msvcrt.dll" Alias "asin" ( _
   ByVal Double _                           ' double x
   ) As Double                              ' double

'_CRTIMP double  __cdecl atan(double);
Declare Function atan_ CDecl Lib "msvcrt.dll" Alias "atan" ( _
   ByVal Double _                           ' double x
   ) As Double                              ' double

'_CRTIMP double  __cdecl atan2(double, double);
Declare Function atan2_ CDecl Lib "msvcrt.dll" Alias "atan2" ( _
   ByVal Double _                           ' double x
   ) As Double                              ' double

'_CRTIMP double  __cdecl cos(double);
Declare Function cos_ CDecl Lib "msvcrt.dll" Alias "cos" ( _
   ByVal Double _                           ' double x
   ) As Double                              ' double

'_CRTIMP double  __cdecl cosh(double);
Declare Function cosh_ CDecl Lib "msvcrt.dll" Alias "cosh" ( _
   ByVal Double _                           ' double x
   ) As Double                              ' double

'_CRTIMP double  __cdecl exp(double);
Declare Function exp_ CDecl Lib "msvcrt.dll" Alias "exp" ( _
   ByVal Double _                           ' double x
   ) As Double                              ' double

'_CRTIMP double  __cdecl fabs(double);
Declare Function fabs_ CDecl Lib "msvcrt.dll" Alias "fabs" ( _
   ByVal Double _                           ' double x
   ) As Double                              ' double

'_CRTIMP double  __cdecl fmod(double, double);
Declare Function fmod_ CDecl Lib "msvcrt.dll" Alias "fmod" ( _
   ByVal Double, _                          ' double x
   ByVal Double _                           ' double y
   ) As Double                              ' double

'_CRTIMP long    __cdecl labs(long);
Declare Function labs_ CDecl Lib "msvcrt.dll" Alias "labs" ( _
   ByVal Long _                             ' long n
   ) As Long                                ' long

'_CRTIMP double  __cdecl log(double);
Declare Function log_ CDecl Lib "msvcrt.dll" Alias "log" ( _
   ByVal Double _                           ' double x
   ) As Double                              ' double

'_CRTIMP double  __cdecl log10(double);
Declare Function log10_ CDecl Lib "msvcrt.dll" Alias "log10" ( _
   ByVal Double _                           ' double x
   ) As Double                              ' double

'_CRTIMP double  __cdecl pow(double, double);
Declare Function pow_ CDecl Lib "msvcrt.dll" Alias "pow" ( _
   ByVal Double, _                          ' double x
   ByVal Double _                           ' double y
   ) As Double                              ' double

'_CRTIMP double  __cdecl sin(double);
Declare Function sin_ CDecl Lib "msvcrt.dll" Alias "sin" ( _
   ByVal Double _                           ' double x
   ) As Double                              ' double

'_CRTIMP double  __cdecl sinh(double);
Declare Function sinh_ CDecl Lib "msvcrt.dll" Alias "sinh" ( _
   ByVal Double _                           ' double x
   ) As Double                              ' double

'_CRTIMP double  __cdecl tan(double);
Declare Function tan_ CDecl Lib "msvcrt.dll" Alias "tan" ( _
   ByVal Double _                           ' double x
   ) As Double                              ' double

'_CRTIMP double  __cdecl tanh(double);
Declare Function tanh_ CDecl Lib "msvcrt.dll" Alias "tanh" ( _
   ByVal Double _                           ' double x
   ) As Double                              ' double

'_CRTIMP double  __cdecl sqrt(double);
Declare Function sqrt_ CDecl Lib "msvcrt.dll" Alias "sqrt" ( _
   ByVal Double _                           ' double x
   ) As Double                              ' double

'_CRTIMP double  __cdecl atof(const char *);
Declare Function atof_ CDecl Lib "msvcrt.dll" Alias "atof" ( _
   ByRef Asciiz _                           ' const char *str
   ) As Double                              ' double

'_CRTIMP double  __cdecl _cabs(struct _complex);
Declare Function cabs_ CDecl Lib "msvcrt.dll" Alias "_cabs" ( _
   ByRef tagComplex _                       ' struct _complex z
   ) As Double                              ' double

'_CRTIMP double  __cdecl ceil(double);
Declare Function ceil_ CDecl Lib "msvcrt.dll" Alias "ceil" ( _
   ByVal Double _                           ' double x
   ) As Double                              ' double

'_CRTIMP double  __cdecl floor(double);
Declare Function floor_ CDecl Lib "msvcrt.dll" Alias "floor" ( _
   ByVal Double _                           ' double x
   ) As Double                              ' double

'_CRTIMP double  __cdecl frexp(double, int *);
Declare Function frexp_ CDecl Lib "msvcrt.dll" Alias "frexp" ( _
   ByVal Double, _                          ' double x
   ByVal Dword _                            ' int *expptr
   ) As Double                              ' double

'_CRTIMP double  __cdecl _hypot(double, double);
Declare Function hypot_ CDecl Lib "msvcrt.dll" Alias "_hypot" ( _
   ByVal Double, _                          ' double x
   ByVal Double _                           ' double y
   ) As Double                              ' double

'_CRTIMP double  __cdecl _j0(double);
Declare Function j0_ CDecl Lib "msvcrt.dll" Alias "_j0" ( _
   ByVal Double _                           ' double x
   ) As Double                              ' double

'_CRTIMP double  __cdecl _j1(double);
Declare Function j1_ CDecl Lib "msvcrt.dll" Alias "_j1" ( _
   ByVal Double _                           ' double x
   ) As Double                              ' double

'_CRTIMP double  __cdecl _jn(int, double);
Declare Function jn_ CDecl Lib "msvcrt.dll" Alias "_jn" ( _
   ByVal Long, _                            ' int n
   ByVal Double _                           ' double x
   ) As Double                              ' double

'_CRTIMP double  __cdecl ldexp(double, int);
Declare Function ldexp_ CDecl Lib "msvcrt.dll" Alias "ldexp" ( _
   ByVal Double, _                          ' double x
   ByVal Long _                             ' int exp
   ) As Double                              ' double

' Not exported.
'_CRTIMP int     __cdecl _matherr(struct _exception *);
'DECLARE FUNCTION matherr_ CDECL LIB "msvcrt.dll" ALIAS "_matherr" ( _
'   BYREF tagException _                     ' struct _exception *except
'   ) AS LONG                                ' int

'_CRTIMP double  __cdecl modf(double, double *);
Declare Function modf_ CDecl Lib "msvcrt.dll" Alias "modf" ( _
   ByVal Double, _                          ' double x
   ByRef Double _                           ' double *intptr
   ) As Double                              ' double

'_CRTIMP double  __cdecl _y0(double);
Declare Function y0_ CDecl Lib "msvcrt.dll" Alias "_y0" ( _
   ByVal Double _                           ' double x
   ) As Double                              ' double

'_CRTIMP double  __cdecl _y1(double);
Declare Function y1_ CDecl Lib "msvcrt.dll" Alias "_y1" ( _
   ByVal Double _                           ' double x
   ) As Double                              ' double

'_CRTIMP double  __cdecl _yn(int, double);
Declare Function yn_ CDecl Lib "msvcrt.dll" Alias "_yn" ( _
   ByVal Long, _                            ' int n
   ByVal Double _                           ' double x
   ) As Double                              ' double


'#pragma pack(pop)

#EndIf   ' #IF NOT %DEF(%MATH_INC)